###########################################################################
# 超小型記号言語(VTS) Python版 Version0.1 (2025/09/20)
###########################################################################
#
#実行環境:
# Python3インタプリタで動作
# 本ソースの文字コードは、UTF-8
# 
#来歴:
# 25/09/20 超小型記号言語Ver1.9をPython3に移植、Ver0.1とする(ただし、ダイレクトモードなし、細かい部分で命令の互換性なし)
#--------------------------
### 変数宣言 ###
fname=""					#プログラムファイル名
prog=""						#プログラム全体
prog1="";prog2="";prog3=""	#プログラム(xxx.vts)/ユーザディクショナリ(usr.dic)/システムディクショナリ(sys.dic)
pc:int=0					#プログラムカウンタ
mem=[int(0)]*65536			#データメモリ
pf:int=0;cf:int=0	 		#プリントフラグ/コメントフラグ
ch=""						#読込命令(1文字)
cc:int=0					#読込命令(ASCII)
word=""						#ワード
us=[int(0)]*65536			#スタック(us)
usp:int=0					#スタックポインタ(usp)
ss=[int(0)]*65536			#システムスタック(ss)
ssp:int=0					#システムスタックポインタ(ssp)
							#スタック演算用変数(a,b,c,d,e)
a:int=0;b:int=0;c:int=0;d:int=0;e:int=0	
i:int=0;j:int=0				#汎用変数(i,j)
temp=""						#汎用文字変数(temp)
ef:int=0					#ループ終了フラグ
bl=""						#条件分岐用ラベル記憶(1文字)
fpath=""					#プログラムとディクショナリの場所(パス)

### タイトル表示処理 ###
print("\nプログラム(xxx.vts)とディクショナリ(xxx.dic)の場所を入力してください")
print("(例1) c:\\test\\")
print("(例2) /home/pi/Desktop/")
print("(例3) /boot/")

fpath=input("?")
f=open(fpath+"sys.dic","r")
temp=f.readline()
f.close
print("\n超小型記号言語(vts) Python版 Version0.1",temp)
print("( プログラムファイル名を入力してください )")

### 入力判定、プログラム読込 ###

while True:
	ef=0	#強制終了フラグの初期値は0
	#1行キー入力
	fname=input("\n?")
	
	#enterだけなら元に戻る(再入力)
	if fname=="":
		continue
		
	### プログラムとディクショナリを読込、文字列に変換 ###
	with open(fpath+fname) as f:
		prog1=f.read()		
	with open(fpath+"usr.dic") as f:
		prog2=f.read()			
	with open(fpath+"sys.dic") as f:
		prog3=f.read()
	prog=prog1+prog2+prog3
	prog=prog.replace("\r\n"," ")	#crlfを空白に置換 (注)↓この順番で置換
	prog=prog.replace("\n"," ")		#lfを空白に置換
	prog=prog.replace("\r"," ")		#crを空白に置換
	
	### プログラム実行 ###
	pc=0									#pcの初期値0
	while pc<=len(prog):					#本ソフトでは、whileを使用(forの代用)
		pc+=1								#pcを+1更新、pc=1(1文字目)からスタート
		ch=prog[pc-1:pc];cc=ord(ch)			#1文字読込 (注)mid(prog,n,m)はPythonではprog[n-1:(n-1)+m]と表記
		
		#(スタックポインタチェック)		
		if usp<0:							#スタックポインタがマイナスになったので、エラー表示
			print("\nSTACK UNDER ERROR\n");usp=0;break
			
		if ssp<0:							#システムスタックポインタがマイナスになったので、エラー表示
			print("\nSYSTEM STACK UNDER ERROR");ssp=0;break

		#(文字プリント、コメント処理)
		if ch=="\"" and pf==0:				#(")プリントモード開始
			pf=1;continue
		if ch=="\""and pf==1:				#(")プリントモード終了
			pf=0;continue 	 
		if pf==1:							#(プリントモードの期間)1文字出力
		 	print(ch,end="");continue
		if ch=="(" and cf==0:				#(()コメントモード開始
		 	cf=1;continue
		if ch==")" and cf==1:				#())コメントモード終了
		 	cf=0;continue
		if cf==1:							#(コメントモードの期間)何もしない
		 	continue

		#(数値、変数、スタック処理)
		if ch=="#":							#(#)数字列先頭(0をpush)
		 	a=0;us[usp]=a;usp+=1;continue
		if cc>=ord("0") and cc<=ord("9"):	#(0-9)u0を10倍後、数字(0-9)を加算
		 	usp-=1;a=us[usp];a=a*10+(cc-ord("0"));us[usp]=a;usp+=1;continue
		if cc>=ord("A") and cc<=ord("Z"):	#(a-z)変数(数字(0-26)に変換)
		 	a=cc-ord("A");us[usp]=a;usp+=1;continue
		if ch=="!":							#(!)スタックトップを読出、変数へ書込
			usp-=1;b=us[usp];usp-=1;a=us[usp];mem[b]=a;continue
		if ch=="@":							#(@)変数を読出、スタックトップへ書込
		 	usp-=1;a=us[usp];a=mem[a];us[usp]=a;usp+=1;continue

		#(入出力処理)
		if ch=="?":							#(?)キーボードから10進数読込
			temp=input("?")
			if temp=="":
				a=int(0)
			else:
				a=int(temp)
			us[usp]=a;usp+=1;continue
		if ch==".":							#(.)10進数プリント
		 	usp-=1;a=us[usp];print(a,end="");continue
		if ch==";":							#(;)改行
		 	print("");continue
		if ch=="\\":						#(\)1文字出力
			print(chr(a));continue

		#(算術、論理演算処理)
		if ch=="+":							#(+)加算
		 	usp-=1;b=us[usp];usp-=1;a=us[usp];a=a+b;us[usp]=a;usp+=1;continue
		if ch=="-":							#(-)減算
		 	usp-=1;b=us[usp];usp-=1;a=us[usp];a=a-b;us[usp]=a;usp+=1;continue
		if ch=="*":							#(*)乗算
		 	usp-=1;b=us[usp];usp-=1;a=us[usp];a=a*b;us[usp]=a;usp+=1;continue
		if ch=="/":							#(/)除算
		 	usp-=1;b=us[usp];usp-=1;a=us[usp];a=a//b;us[usp]=a;usp+=1;continue
		if ch=="%":							#(%)剰余
			usp-=1;b=us[usp];usp-=1;a=us[usp];a=a%b;us[usp]=a;usp+=1;continue
		if ch=="<":							#(<)判定(a<b)
			usp-=1;b=us[usp];usp-=1;a=us[usp];a=a<b;us[usp]=a;usp+=1;continue
		if ch==">":							#(>)判定(a>b)
			usp-=1;b=us[usp];usp-=1;a=us[usp];a=a>b;us[usp]=a;usp+=1;continue
		if ch=="=":							#(=)判定(a=b)
			usp-=1;b=us[usp];usp-=1;a=us[usp];a=(a==b);us[usp]=a;usp+=1;continue
		if ch=="&":							#(&)and
			usp-=1;b=us[usp];usp-=1;a=us[usp];a=a and b;us[usp]=a;usp+=1;continue
		if ch=="|":							#(|)or
			usp-=1;b=us[usp];usp-=1;a=us[usp];a=a or  b;us[usp]=a;usp+=1;continue
		if ch=="^":							#(^)not
			usp-=1;a=us[usp];a=not a;us[usp]=a;usp+=1;continue

		#(実行終了処理)
		if ch=="{":							#({)プログラム実行終了(ワード定義領域先頭に到達したため、for～から抜ける)
		 	break

		#(ワード(サブルーチン)開始処理)
		if ch==":":							#(:)ワード実行開始(戻り番地をpush後、ワード定義まで検索・移動)
			word=""
			i=pc+1	#:の次から空白の手前までの文字列を取得
			while prog[i-1:i]!=" ":
				word+=prog[i-1:i]
				i+=1
			e=i;ss[ssp]=e;ssp+=1	#ワード実行後の戻り位置(ワード直後の空白位置)を記憶
			i=1	#先頭からワード定義(飛び先)を検索
			while not((prog[i-1:i]=="{") and prog[i:i+len(word)]==word and prog[i+len(word):i+len(word)+1]==" "): 
				i=i+1
				if i==len(prog):
					print("\nWORD NOT FOUND = ");word;ef=1;break	#ワード定義が見つからなかったので、エラー表示
			if ef==1:	#上記エラーを受けてbreak
				break
			pc=i+len(word);continue	#ワード定義が見つかったので移動

		#(ワード(サブルーチン)終了処理)	
		if ch=="}":							#(})ワード実行終了(戻り番地をpop後、戻り番地に移動)
			ssp-=1;e=ss[ssp];pc=e;continue

		#(条件分岐処理)
		if cc>=ord("a") and cc<=ord("z"):	#(a-z)分岐元ラベル(a～z)を変数(bl)に記憶
			bl=ch;continue
			
		if ch=="[":							#([)分岐先ラベル記号は何もしないでスキップ
			pc=pc+1;continue

		if ch=="]":							#(])条件分岐(条件成立でローカルラベル[a…[zまで移動)
			usp-=1;a=us[usp]
			if a==True:	#判定結果が真なら、ローカル範囲先頭({)またはメインプログラム先頭を前方検索
				j=1	#現在の位置(pc)から、ワードまたはメインプログラム先頭にpcを移動
				for i in range(pc,0,-1):
					if prog[i-1:i]=="{":
						j=i;break
				pc=j
				
				while not(prog[pc-1:pc]=="[" and prog[pc:pc+1]==bl):	#変数(bl)に記憶していたラベル(a～z)を検索、移動(ジャンプ)
					pc=pc+1
				pc=pc+1

	#↓ここはwhile構文の末尾(変数pcのループ)
#↓ここはwhile構文の末尾(無限ループ)
