' このコードは自由にお使いください。(2025/11/30)

'--------------------------------------------------------------------------------
' このｺｰﾄﾞをｱｾﾝﾌﾞﾙするには｢ASCII2.LIB｣ﾌｧｲﾙが必要です｡
' 具体的には､次の2行を記述した「xxx.INC｣というﾃｷｽﾄﾌｧｲﾙを作成します｡
'
' ASCII2.LIB
' VTS.ASM
'
' ｱｾﾝﾌﾞﾗASMB!を起動後｢xxx.INC｣をｷｰ入力すると､ｱｾﾝﾌﾞﾙを開始ます｡
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'【解説】CPUのｱﾄﾞﾚｽ、ﾃﾞｰﾀ、定数
'RAM空間=000h～FFFh(4Kﾊﾞｲﾄ)、ROM空間=0000h～FFFFh(64Kﾊﾞｲﾄ)
'ﾌｧｰﾑｳｪｱでRP=0と設定しているので、ﾜｰｷﾝｸﾞﾚｼﾞｽﾀr0～15とRAM0～15番地は同じﾒﾓﾘ
'(例)「INC r12」は、RAMの12番地のﾃﾞｰﾀを+1します。
'ｱｾﾝﾌﾞﾗ「ASMB!」の数値、ﾗﾍﾞﾙの表記ﾙｰﾙは次の通り(純正ｱｾﾝﾌﾞﾗと互換性なし)
' rdd      = ﾜｰｷﾝｸﾞﾚｼﾞｽﾀ(rは大文字表記可)
' rrdd     = ﾍﾟｱ(16ﾋﾞｯﾄ)ﾚｼﾞｽﾀ(rrは大文字表記可)
' ddddd    = 10進数ｱﾄﾞﾚｽ(EQU/DB命令を除く)
' %hhhh    = 16進数ｱﾄﾞﾚｽ(EQU/DB命令を除く)
' #ddd     = 10進数定数
' #%hh     = 16進数定数
' :xxxxxx  = ﾗﾍﾞﾙ(ｱﾄﾞﾚｽ)
' #:xxxxxx = ﾗﾍﾞﾙ(定数)
'--------------------------------------------------------------------------------
'--------------------------------------------------------------------------------
'【解説】ﾆｰﾓﾆﾂｸ末尾のX/Wの意味
'一部例外があるが、ﾆｰﾓﾆﾂｸ末尾のX/Wの意味は次の通り
'末尾の「X」    = ｱﾄﾞﾚｽ 000h～FFFh
'末尾の「Xなし」= ｱﾄﾞﾚｽ  00h～ FFh(ｾﾞﾛﾍﾟｰｼﾞ)
'末尾の「W」    = ﾜｰﾄﾞ(16ﾋﾞｯﾄ)ﾃﾞｰﾀ
'末尾の「Wなし」= ﾊﾞｲﾄﾃﾞｰﾀ
'(例1) LDWX = LD(ﾛｰﾄﾞ) + W(ﾜｰﾄﾞﾃﾞｰﾀ) + X(ｱﾄﾞﾚｽ 000h～FFFh)
'(例2) LDX  = LD(ﾛｰﾄﾞ) +  (ﾊﾞｲﾄﾃﾞｰﾀ) + X(ｱﾄﾞﾚｽ 000h～FFFh)
'(例3) LD   = LD(ﾛｰﾄﾞ) +  (ﾊﾞｲﾄﾃﾞｰﾀ) +  (ｱﾄﾞﾚｽ  00h～ FFh)
'--------------------------------------------------------------------------------
'******************************
'No.100 RAM/ROM
'******************************
'機能:
'入力:
'出力:
'******************************
'(1)RAM ※ｱﾌﾟﾘが自由に使えるｾﾞﾛﾍﾟｰｼﾞはD0h～DFhの16ﾊﾞｲﾄのみ
'%0D0-%0DF(ﾜｰｷﾝｸﾞｴﾘｱ)
:PC		EQU %D0		'ﾌﾟﾛｸﾞﾗﾑｶｳﾝﾀ(初期値264=108h)
:PCL	EQU %D1	
:EOP	EQU %D2		'ﾌﾟﾛｸﾞﾗﾑ末+1(変数&の値)
:EOPL	EQU %D3
:REGA	EQU %D4		'ﾚｼﾞｽﾀA
:REGAL	EQU %D5		'
:REGB	EQU %D6		'ﾚｼﾞｽﾀB
:REGBL	EQU %D7
:OPC	EQU %D8		'ｵﾍﾟｺｰﾄﾞ(PCの示す1文字)
:PF		EQU %D9		'ﾌﾟﾘﾝﾄﾌﾗｸﾞ(1:ﾌﾟﾘﾝﾄ文字列中)
:CF		EQU %DA		'ｺﾒﾝﾄﾌﾗｸﾞ (1:ｺﾒﾝﾄ文字列中)
:JPLB	EQU %DB		'ｼﾞｬﾝﾌﾟ先ﾗﾍﾞﾙ (a-z)
:SKPF	EQU %DC		'ｽｷｯﾌﾟﾌﾗｸﾞ(1:ｽｷｯﾌ中) ※CR/LF/行番号をｽｷｯﾌﾟ
'%108-%7FF(ﾕｰｻﾞﾌﾟﾛｸﾞﾗﾑ)
'%800-%BFF(ﾃﾞｰﾀﾒﾓﾘ)
:MEM	EQU %800	'VTS言語のﾃﾞｰﾀﾒﾓﾘ(0～511番地)
'%C00-%C11(ｽﾀｯｸ)
:US0	EQU %C00	'VTS言語のｽﾀｯｸ0(TOS)
:US1	EQU %C02	'VTS言語のｽﾀｯｸ1
:US2	EQU %C04	'VTS言語のｽﾀｯｸ2
:US3	EQU %C06	'VTS言語のｽﾀｯｸ3
:US4	EQU %C08	'VTS言語のｽﾀｯｸ4
:US5	EQU %C10	'VTS言語のｽﾀｯｸ5
'(2)ROM
'%038-%065(ﾌｧｰﾑｳｪｱのｼｽﾃﾑｺｰﾙ)
:START	EQU %38		'ｼｽﾃﾑｺｰﾙ38h(56) ｼｽﾃﾑｽﾀｰﾄ
:OUT1C	EQU %3B		'ｼｽﾃﾑｺｰﾙ3Bh(59) 1文字出力(R0)
:INP1C	EQU %3E		'ｼｽﾃﾑｺｰﾙ3Eh(62) 1文字入力(R0)
:CKESC	EQU %41		'ｼｽﾃﾑｺｰﾙ41h(65) ESCｷｰ入力ﾁｪｯｸ(C)
:BLINK	EQU %4A		'ｼｽﾃﾑｺｰﾙ4Ah(74) LED点滅
:T1S	EQU %4D		'ｼｽﾃﾑｺｰﾙ4Dh(77) 1sﾀｲﾏ
:T100MS	EQU %50		'ｼｽﾃﾑｺｰﾙ50h(80) 100msﾀｲﾏ
'--------------------------------------------------------------------------------
'【解説】
'68番地以降のｼｽﾃﾑｺｰﾙは、次のﾊﾞｰｼﾞｮﾝ以上でｻﾎﾟｰﾄ
' Micro BASIC for ZCPU1 Version 1.03
' Micro BASIC for ZCPU3 Version 1.01
'--------------------------------------------------------------------------------
'%068～%095(ﾌｧｰﾑｳｪｱのｼｽﾃﾑｺｰﾙ)
:OUT1N	EQU %68		'ｼｽﾃﾑｺｰﾙ68h(104) 数字1桁出力(R0)
:OUTNN	EQU %6B		'ｼｽﾃﾑｺｰﾙ6Bh(107) 10進数出力(RR0)
:VALNN	EQU %6E		'ｼｽﾃﾑｺｰﾙ6Eh(110) N桁数値変換(RR8=R10～)
:MUL10	EQU %71		'ｼｽﾃﾑｺｰﾙ71h(113) 2ﾊﾞｲﾄ10倍演算(RR0)
:ADDW	EQU %74		'ｼｽﾃﾑｺｰﾙ74h(116) ﾜｰﾄﾞ加算(RR12=RR8+RR10)
:SUBW	EQU %77		'ｼｽﾃﾑｺｰﾙ77h(119) ﾜｰﾄﾞ減算(RR12=RR8-RR10)
:MULW	EQU %7A		'ｼｽﾃﾑｺｰﾙ7Ah(122) ﾜｰﾄﾞ乗算(RR12=RR8*RR10)
:DIVW	EQU %7D		'ｼｽﾃﾑｺｰﾙ7Dh(125) ﾜｰﾄﾞ除算(RR14=RR8/RR10,RR12=RR8%RR10)
:LTW	EQU %80		'ｼｽﾃﾑｺｰﾙ80h(128) ﾜｰﾄﾞ比較(RR12=RR8<RR10)
:GTW	EQU %83		'ｼｽﾃﾑｺｰﾙ83h(131) ﾜｰﾄﾞ比較(RR12=RR8>RR10)
:EQW	EQU %86		'ｼｽﾃﾑｺｰﾙ86h(134) ﾜｰﾄﾞ比較(RR12=RR8=RR10)

'******************************
'No.101 ﾍｯﾀﾞｰ(ROMﾃﾞｨﾚｸﾄﾘ表示)	
'******************************
'機能:%1600番地から16ﾊﾞｲﾄの設定
'入力:
'出力:
'******************************
'ROMの1600H番地からｱﾌﾟﾘを配置(=5632番地)
		ORG %1600
'ｱﾌﾟﾘ先頭ﾊﾟﾀｰﾝ
:PTN1   EQU %8B		'ｱﾌﾟﾘ先頭ﾊﾟﾀｰﾝ1(8BH)
:PTN2   EQU %0E		'ｱﾌﾟﾘ先頭ﾊﾟﾀｰﾝ2(0EH)
:PTN3   EQU %3F		'ｱﾌﾟﾘ先頭ﾊﾟﾀｰﾝ3(3FH)
:PTN4   EQU %D9		'ｱﾌﾟﾘ先頭ﾊﾟﾀｰﾝ3(D9H)
'ｱﾌﾟﾘ名称
:NAM1   EQU :CH_V	'ｱﾌﾟﾘ名称1(V)
:NAM2   EQU :CH_T	'ｱﾌﾟﾘ名称2(T)
:NAM3   EQU :CH_S	'ｱﾌﾟﾘ名称3(S)
:NAM4   EQU :CH_SLS	'ｱﾌﾟﾘ名称4(/)
:NAM5   EQU :CH_E	'ｱﾌﾟﾘ名称5(E)
:NAM6   EQU :CH_Z	'ｱﾌﾟﾘ名称6(Z)
:NAM7   EQU :CH_8	'ｱﾌﾟﾘ名称7(8)
:NAM8   EQU :CH_SP	'ｱﾌﾟﾘ名称8( )
:NAM9   EQU :CH_0	'ｱﾌﾟﾘ名称9(0)
:NAM10  EQU :CH_DOT	'ｱﾌﾟﾘ名称10(.)
:NAM11  EQU :CH_1	'ｱﾌﾟﾘ名称11(1)
:NAM12  EQU :CH_SP	'ｱﾌﾟﾘ名称12( )
'ｱﾌﾟﾘ先頭ﾊﾟﾀｰﾝ(4ﾊﾞｲﾄ)をROMに配置
'(ｱﾌﾟﾘ先頭の目印と%1610番地へのｼﾞｬﾝﾌﾟ命令を兼ねる)
	DB :PTN1
	DB :PTN2
	DB :PTN3
	DB :PTN4
'ｱﾌﾟﾘ名称(12ﾊﾞｲﾄ)をROMに配置
	DB :NAM1	'VTS/EZ8 0.1
	DB :NAM2	
	DB :NAM3
	DB :NAM4
	DB :NAM5
	DB :NAM6
	DB :NAM7
	DB :NAM8
	DB :NAM9
	DB :NAM10
	DB :NAM11
	DB :NAM12

'******************************
'No.110 VTS
'******************************
'機能:VTSｲﾝﾀﾌﾟﾘﾀのﾒｲﾝﾙｰﾁﾝ
'入力:
'出力:
'******************************
'ｱﾌﾟﾘ先頭(1600h番地)から､ここ(1610h番地)に飛んでくる
:VTS
	CALL :INIT		'初期設定
:L1100
	CALL :FETCH		'命令読込(OPC、PCを更新)
	JR /C,:L1101	'ﾌﾟﾛｸﾞﾗﾑ末またはｴﾗｰ(C=1)なら、ﾏｲｸﾛBASICへ戻る
'ﾌﾟﾘﾝﾄ、ｺﾒﾝﾄ、ｼﾞｬﾝﾌﾟの処理
	CALL :EXEC1		'命令処理1(特殊命令)
	JR /C,:L1100	'処理済(C=1)なら、次の命令へ
'数字、演算子などの処理
	CALL :EXEC2		'命令実行2(通常命令)
	JR /C,:L1100	'処理済(C=1)なら、次の命令へ
'ﾏｲｸﾛBASICに戻る
:L1101
	RET

'******************************
'No.111 INIT
'******************************
'機能:初期設定
'入力:
'出力:
'******************************
:INIT
	LD :PC,#%01		'PC=264(ﾌﾟﾛｸﾞﾗﾑ先頭)【解説】#はｲﾐﾃﾞｨｴｲﾄ(即値)ﾃﾞｰﾀ
	LD :PCL,#%08
	LD :EOP,%68		'EOP=ﾏｲｸﾛBASICの変数&(ﾌﾟﾛｸﾞﾗﾑ末+1)
	LD :EOPL,%69
	CLR	:OPC		'ｵﾍﾟｺｰﾄﾞ  =0
	CLR	:PF			'ﾌﾟﾘﾝﾄﾌﾗｸﾞ=0
	CLR	:CF			'ｺﾒﾝﾄﾌﾗｸﾞ =0
	LD :SKPF,#1		'ｽｷｯﾌﾟﾌﾗｸﾞ=1(行番号から開始)
	RET

'******************************
'No.112 FETCH
'******************************
'機能:命令読込後、PCを更新
'入力:PC,SKPF
'出力:PC,SKPF,OPC,C(ﾌﾟﾛｸﾞﾗﾑ末)
'******************************
:FETCH
'ﾌﾟﾛｸﾞﾗﾑ末ﾁｪｯｸ
	CP :PC,:EOP		'ﾌﾟﾛｸﾞﾗﾑ末+1と比較
	JR /NE,:L1120
	CP :PCL,:EOPL
	JR /NE,:L1120
	SCF				'ﾌﾟﾛｸﾞﾗﾑ末(C=1)
	RET
'--------------------------------------------------------------------------------
'【解説】@は間接ｱﾄﾞﾚｯｼﾝｸﾞ
'--------------------------------------------------------------------------------
'CR/LFﾁｪｯｸ
:L1120
	LDX :OPC,@:PC	'命令読込(OPCに保存)
	CP :OPC,#:CH_CR	'CRならｽｷｯﾌﾟ
	JR /EQ,:L1121
	CP :OPC,#:CH_LF	'LFならｽｷｯﾌﾟ
	JR /NE,:L1122
:L1121
	LD :SKPF,#1		'SKPF=1
	INCW :PC		'PCを+1
	JR :FETCH		'次の命令へ(ｽｷｯﾌﾟ)
'CR/LF(行末)以外
:L1122
	CP :SKPF,#0		'行番号以外(SKPF=0)なら命令確定
	JR /EQ,:L1123
	CP :OPC,#:CH_SP	'行番号中(SKPF=1)の空白出現でも命令確定
	JR /EQ,:L1123
	JR :L1121		'上記以外なら行番号を継続(ｽｷｯﾌﾟ)
'命令確定
:L1123
	CLR :SKPF		'SKPF=0
	INCW :PC		'PCを+1
	RCF				'ﾌﾟﾛｸﾞﾗﾑ途中(C=0)、OPC=命令
	RET

'******************************
'No.113 EXEC1
'******************************
'機能:命令処理1(特殊命令)
'入力:
'出力:C(0:未処理、1:命令処理)
'******************************
:EXEC1
	LD 0,:OPC		'ｵﾍﾟｺｰﾄﾞ読込
'命令判定(1) ※文字列出力
	CP 0,#:CH_QUO	'(OP=" & PF=0)
	JR /NE,:L1130
	CP :PF,#0
	JR /EQ,:L1131
	JR :L1132		'(OP=" & PF=1)
:L1130
	CP :PF,#1		'(PF=1)
	JR /EQ,:L1133
	JR :L11310		'命令判定(2)へ
'命令処理(1)
'(OP=" & PF=0)
:L1131
	LD :PF,#1		'PF=1
	SCF				'命令処理(C=1)
	RET
'(OP=" & PF=1)
:L1132
	CLR :PF			'PF=0
	SCF				'命令処理(C=1)
	RET
'(PF=1)
:L1133
	LD 0,:OPC
	CALL :OUT1C		'1文字出力
	SCF				'命令処理(C=1)
	RET
'命令判定(2) ※コメント
:L11310
	CP 0,#:CH_LFT	'(OP=( & CF=0)
	JR /NE,:L11311
	CP :CF,#0
	JR /EQ,:L11313
:L11311
	CP 0,#:CH_RIT	'(OP=) & CF=1)
	JR /NE,:L11312
	CP :CF,#1
	JR /EQ,:L11314
:L11312
	CP :CF,#1		'(CF=1)
	JR /EQ,:L11315
	JR :L11340		'命令未処理へ
'命令処理(2)
'(OP=( & CF=0)
:L11313
	LD :CF,#1		'CF=1
	SCF				'命令処理(C=1)
	RET
'(OP=) & CF=1)
:L11314
	CLR :CF			'CF=0
	SCF				'命令処理(C=1)
	RET
'(CF=1)
:L11315
	SCF				'命令処理(C=1)
	RET
'命令未処理
:L11340
	RCF				'命令未処理(C=0)
	RET
	
'******************************
'No.114 EXEC2
'******************************
'機能:命令実行2(通常命令)
'入力:OP
'出力:CF(0:命令未処理、1:命令処理)
'******************************
:EXEC2
	LD 0,:OPC		'ｵﾍﾟｺｰﾄﾞ読込
'***************
'命令判定(1)
'***************
	CP 0,#:CH_SP	'( )空白
	JP /EQ,:L1141
	CP 0,#:CH_NUM	'(#)数字先頭
	JP /EQ,:L1142
	CP 0,#:CH_0		'(0-9)数字
	JP /C,:L1140
	CP 0,#:CH_9
	JP /ULE,:L1143
:L1140
	CP 0,#:CH_PLS	'(+)加算
	JP /EQ,:L1144
	CP 0,#:CH_MIN	'(-)減算
	JP /EQ,:L1145
	CP 0,#:CH_AST	'(*)乗算
	JP /EQ,:L1146
	CP 0,#:CH_SLS	'(/)除算
	JP /EQ,:L1147
	CP 0,#:CH_PER	'(%)除余
	JP /EQ,:L1148
	CP 0,#:CH_DOT	'(.)数値出力
	JP /EQ,:L1149
	JP :L11420		'命令判定(2)へ
'***************
'命令処理(1)
'***************
'( )空白
:L1141
	SCF				'命令処理(C=1)
	RET
'(#)数字先頭
:L1142
	CLR :REGA		'ﾚｼﾞｽﾀA=0
	CLR :REGAL
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(0-9)数字 ※TOS=TOS*10+数値(0～9)
:L1143
	SUB 0,#:CH_0	'数値化
	CLR 10			'数値を待避(RR10)	
	LDX 11,0
	LDWX 0,:US0
	CALL :MUL10		'ｼｽﾃﾑｺｰﾙ(RR0=RR0*10)
	LDWX 8,0
	CALL :ADDW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8+RR10)	
	LDWX :US0,12	'US0に戻す
	SCF				'命令処理(C=1)
	RET
'(+)加算
:L1144
	CALL :POPUS		'POP(演算数)
	LDWX 10,:REGA
	CALL :POPUS		'POP(被演算数)
	LDWX 8,:REGA
	CALL :ADDW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8+RR10)
	LDWX :REGA,12	'PUSH(演算結果)
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(-)減算
:L1145
	CALL :POPUS		'POP(演算数)
	LDWX 10,:REGA
	CALL :POPUS		'POP(被演算数)
	LDWX 8,:REGA
	CALL :SUBW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8-RR10)
	LDWX :REGA,12	'PUSH(演算結果)
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(*)乗算
:L1146
	CALL :POPUS		'POP(演算数)
	LDWX 10,:REGA
	CALL :POPUS		'POP(被演算数)
	LDWX 8,:REGA
	CALL :MULW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8*RR10)
	LDWX :REGA,12	'PUSH(演算結果)
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(/)除算
:L1147
	CALL :POPUS		'POP(演算数)
	LDWX 10,:REGA
	CALL :POPUS		'POP(被演算数)
	LDWX 8,:REGA
	CALL :DIVW		'ｼｽﾃﾑｺｰﾙ(RR14=RR8*RR10)
	LDWX :REGA,14	'除算(演算結果)
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(%)除余
:L1148
	CALL :POPUS		'POP(演算数)
	LDWX 10,:REGA
	CALL :POPUS		'POP(被演算数)
	LDWX 8,:REGA
	CALL :DIVW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8%RR10)
	LDWX :REGA,12	'除算(演算結果)	
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(.)数値出力
:L1149
	CALL :POPUS		'POP(演算数)
	LDWX 0,:REGA
	CALL :OUTNN		'ｼｽﾃﾑｺｰﾙ(RR0)
	SCF				'命令処理(C=1)
	RET
'***************
'命令判定(2)
'***************
:L11420
	CP 0,#:CH_SCO	'(;)改行
	JP /EQ,:L11421
	CP 0,#:CH_LT	'(<)比較<
	JP /EQ,:L11422
	CP 0,#:CH_GT	'(>)比較>
	JP /EQ,:L11425	
	CP 0,#:CH_EQ	'(=)比較=
	JP /EQ,:L11426
	CP 0,#:CH_AMP	'(&)AND
	JP /EQ,:L11427
	CP 0,#:CH_VER	'(|)OR
	JP /EQ,:L11428
	CP 0,#:CH_HAT	'(^)NOT
	JP /EQ,:L11429
	CP 0,#:CH_REV	'(\)文字コード出力
	JP /EQ,:L11430
	JP :L11440		'命令判定(3)へ
'***************
'命令処理(2)
'***************
'(;)改行
:L11421
	LD r0,#:CH_CR	'CR
	CALL :OUT1C		'ｼｽﾃﾑｺｰﾙ(RR0)
	SCF				'命令処理(C=1)
	RET
'(<)比較<
:L11422
	CALL :POPUS		'POP(演算数)
	LDWX 10,:REGA
	CALL :POPUS		'POP(被演算数)
	LDWX 8,:REGA
	CALL :LTW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8<RR10)
'(0001h→FFFFh補正)
:l11423
	CP 13,#%00		'TRUE(xx00h)?
	JR /EQ,:L11424
	LD 12,#%FF		'FALSE(FFFFh)
	LD 13,#%FF
:L11424
	LDWX :REGA,12	'PUSH(演算結果)
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(>)比較>
:L11425
	CALL :POPUS		'POP(演算数)
	LDWX 10,:REGA
	CALL :POPUS		'POP(被演算数)
	LDWX 8,:REGA
	CALL :GTW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8>RR10)
	JR :L11423
'(=)比較=
:L11426
	CALL :POPUS		'POP(演算数)
	LDWX 10,:REGA
	CALL :POPUS		'POP(被演算数)
	LDWX 8,:REGA
	CALL :EQW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8=RR10)
	JR :L11423
'(&)AND
:L11427
	CALL :POPUS		'POP(演算数)
	LDWX :REGB,:REGA
	CALL :POPUS		'POP(被演算数)
	AND :REGA,:REGB
	AND :REGAL,:REGBL
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(|)OR
:L11428
	CALL :POPUS		'POP(演算数)
	LDWX :REGB,:REGA
	CALL :POPUS		'POP(被演算数)
	OR :REGA,:REGB
	OR :REGAL,:REGBL
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(^)NOT
:L11429
	CALL :POPUS		'POP(被演算数)
	COM :REGA
	COM :REGAL
	OR :REGAL,:REGBL
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(\)文字ｺｰﾄﾞ出力
:L11430
	CALL :POPUS		'POP(演算数)
	LDWX 0,:REGAL
	CALL :OUT1C		'ｼｽﾃﾑｺｰﾙ(RR0)
	SCF				'命令処理(C=1)
	RET
'***************
'命令判定(3)
'***************
:L11440
	CP 0,#:CH_A		'(A-Z)変数名
	JP /C,:L11441
	CP 0,#:CH_Z
	JP /ULE,:L11443	
:L11441
	CP 0,#:CH_EXC	'(!)ｾｰﾌﾞ
	JP /EQ,:L11444
	CP 0,#:CH_CAT	'(@)ﾛｰﾄﾞ
	JP /EQ,:L11445
	CP 0,#:CH_QUE	'(?)数値入力
	JP /EQ,:L11446
	CP 0,#:CH_LLT	'([)分岐先ﾗﾍﾞﾙ記号
	JP /EQ,:L11449
	CP 0,#:CH__A	'(a-z)ﾗﾍﾞﾙ
	JP /C,:L11442
	CP 0,#:CH__Z
	JP /ULE,:L11450
:L11442
	CP 0,#:CH_LRT	'(])条件分岐
	JP /EQ,:L11451
	JP :L11460		'未定義命令へ
'***************
'命令処理(3)
'***************
'(A-Z)変数名
:L11443
	SUB 0,#:CH_A	'数値化
	CLR :REGA
	LD :REGAL,0
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'(!)ｾｰﾌﾞ
:L11444
	CALL :POPUS		'ﾃﾞｰﾀ→REGA
	LDWX :REGB,:REGA
	CALL :POPUS
	RCF				'ｱﾄﾞﾚｽ計算→REGB(0800h～)
	RLC :REGBL
	RLC :REGB
	ADD :REGB,#%08
	LDX @:REGB,:REGA 'ｾｰﾌﾞ
	INCW :REGB
	LDX @:REGB,:REGAL
	SCF				'命令処理(C=1)
	RET
'(@)ﾛｰﾄﾞ
:L11445
	CALL :POPUS		'POP(ｱﾄﾞﾚｽ)
	RCF				'ﾜｰﾄﾞ→ﾊﾞｲﾄ変換
	RLC :REGAL
	RLC :REGA
	ADD :REGA,#%08	'ｱﾄﾞﾚｽ(REGA)
	LDX :REGB,@:REGA
	INCW :REGA
	LDX :REGBL,@:REGA
	LDWX :REGA,:REGB
	CALL :PSHUS		'PUSH(ﾃﾞｰﾀ)
	SCF				'命令処理(C=1)
	RET
'(?)数値入力
:L11446
	CLR :REGA		'REGA=0(累積ﾚｼﾞｽﾀ)
	CLR :REGAL
:L11447
	CALL :INP1C		'数字入力
	CALL :OUT1C		'ｴｺｰﾊﾞｯｸ
	CP 0,#:CH_CR	'CRなら終了
	JR /EQ,:L11448
	SUB 0,#:CH_0	'数値化
	CLR 10			'数値を待避(RR10)
	LDX 11,0
	LDWX 0,:REGA
	CALL :MUL10		'ｼｽﾃﾑｺｰﾙ(RR0=RR0*10)
	LDWX 8,0
	CALL :ADDW		'ｼｽﾃﾑｺｰﾙ(RR12=RR8+RR10)
	LDWX :REGA,12	'REGAに戻す
	JR :L11447
:L11448
	CALL :PSHUS		'ｽﾀｯｸUSにPUSH
	SCF				'命令処理(C=1)
	RET
'([)分岐元ﾗﾍﾞﾙ記号 ※何もしない
:L11449
	SCF				'命令処理(C=1)
	RET	
'(a-z)ﾗﾍﾞﾙ名
:L11450
	LD :JPLB,0		'a-zを記憶 ※分岐元/分岐先は区別しない
	SCF				'命令処理(C=1)
	RET
'(])条件分岐
:L11451
	CALL :POPUS		'POP(真/偽)
	CP :REGA,#%00	'偽(0)ならｽｷｯﾌﾟ
	JR /NE,:L11452
	CP :REGAL,#%00
	JR /EQ,:L11455
:L11452
	LD :PC,#%01		'記憶ﾗﾍﾞﾙ(JPLB)をﾌﾟﾛｸﾞﾗﾑ先頭から検索
	LD :PCL,#%08
:L11453
	LDX :OPC,@:PC	'命令読込(OPCに保存)
	CP :OPC,#:CH_LLT'ﾗﾍﾞﾙ記号([)
	JR /NE,:L11454
	INCW :PC		'PC=PC+1
	LDX :OPC,@:PC	'命令読込(OPCに保存)
	CP :OPC,:JPLB	'ﾗﾍﾞﾙ一致
	JR /EQ,:L11455
:L11454
	INCW :PC		'PC=PC+1
	JR :L11453
:L11455
	INCW :PC		'PC=PC+1
	SCF				'命令処理(C=1)
	RET
'***************
'未定義命令
'***************
:L11460
	CALL :OUT1C		'1文字出力(未定義命令)
	LD 0,:CH_QUE
	CALL :OUT1C		'1文字出力(?)	
	RCF				'命令未処理(C=0)
	RET
	
'******************************
'No.200 PSHUS
'******************************
'機能:
'入力:USx,REGA
'出力:USx
'******************************
:PSHUS
	LDWX :US5,:US4
	LDWX :US4,:US3
	LDWX :US3,:US2
	LDWX :US2,:US1
	LDWX :US1,:US0
	LDWX :US0,:REGA
	RET	

'******************************
'No.201 POPUS
'******************************
'機能:
'入力:USx
'出力:USx,REGA
'******************************
:POPUS
	LDWX :REGA,:US0
	LDWX :US0,:US1
	LDWX :US1,:US2
	LDWX :US2,:US3
	LDWX :US3,:US4
	LDWX :US4,:US5
	RET
